<?php

declare(strict_types=1);

namespace App\Repositories\Eloquent\Blog;

use App\Models\Blog\PostCategory;
use App\Repositories\Contracts\Blog\PostCategoryRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class PostCategoryRepository implements PostCategoryRepositoryInterface
{
    public function getAll(array $args = []): Builder
    {
        $query = PostCategory::query();
        
        if (!empty($args['search'])) {
            $query->where(function($q) use ($args) {
                $q->where('name', 'like', '%' . $args['search'] . '%')
                  ->orWhere('description', 'like', '%' . $args['search'] . '%');
            });
        }
        
        return $query;
    }

    public function find(int $id): ?Model
    {
        return PostCategory::find($id);
    }
    
    public function findBySlug(string $slug): ?Model
    {
        return PostCategory::where('slug', $slug)->first();
    }

    public function getBySlug(array $slugs): \Illuminate\Support\Collection
    {
        return PostCategory::whereIn('slug', $slugs)->get();
    }

    public function create(array $data): Model
    {
        return PostCategory::create($data);
    }

    public function update(int $id, array $data): bool
    {
        return PostCategory::find($id)->update($data);
    }

    public function delete(int $id): bool
    {
        return PostCategory::find($id)->delete();
    }
} 