<?php

declare(strict_types=1);

namespace App\Repositories\Eloquent\Blog;

use App\Models\Blog\PostTag;
use App\Repositories\Contracts\Blog\PostTagRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class PostTagRepository implements PostTagRepositoryInterface
{
    public function getAll(array $args = []): Builder
    {
        $query = PostTag::query();
        
        if (!empty($args['search'])) {
            $query->where(function($q) use ($args) {
                $q->where('name', 'like', '%' . $args['search'] . '%')
                  ->orWhere('description', 'like', '%' . $args['search'] . '%');
            });
        }
        
        return $query;
    }

    public function find(int $id): ?Model
    {
        return PostTag::find($id);
    }
    
    public function findBySlug(string $slug): ?Model
    {
        return PostTag::where('slug', $slug)->first();
    }

    public function create(array $data): Model
    {
        return PostTag::create($data);
    }

    public function update(int $id, array $data): bool
    {
        return PostTag::find($id)->update($data);
    }

    public function delete(int $id): bool
    {
        return PostTag::find($id)->delete();
    }
} 