<?php

declare(strict_types=1);

namespace App\Repositories\Eloquent\Classified;

use App\Models\Classified\ClassifiedCategory;
use App\Repositories\Contracts\Classified\ClassifiedCategoryRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Collection;


class ClassifiedCategoryRepository implements ClassifiedCategoryRepositoryInterface
{
    public function getAll(array $args = []): Builder
    {
        $query = ClassifiedCategory::query();
        
        if (!empty($args['search'])) {
            $query->where(function($q) use ($args) {
                $q->where('name', 'like', '%' . $args['search'] . '%')
                  ->orWhere('description', 'like', '%' . $args['search'] . '%');
            });
        }


        
        return $query;
    }
    public function getParentCategories(): Collection
    {
        return ClassifiedCategory::whereNull('parent_id')->get();
    }

    public function find(int $id): ?Model
    {
        return ClassifiedCategory::find($id);
    }
    
    public function findBySlug(string $slug): ?ClassifiedCategory
    {
        return ClassifiedCategory::where('slug', $slug)->first();
    }

    public function getChildCategories(int $parentId): Collection
    {
        return ClassifiedCategory::where('parent_id', $parentId)->get();
    }

    public function create(array $data): Model
    {
        return ClassifiedCategory::create($data);
    }

    public function update(int $id, array $data): bool
    {
        return ClassifiedCategory::find($id)->update($data);
    }

    public function delete(int $id): bool
    {
        return ClassifiedCategory::find($id)->delete();
    }
} 