<?php

namespace App\Repositories\Eloquent\Classified;

use App\Repositories\Contracts\Classified\ClassifiedDeliveryRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use App\Models\Classified\ClassifiedDelivery;
use Illuminate\Database\Eloquent\Collection;

class ClassifiedDeliveryRepository implements ClassifiedDeliveryRepositoryInterface
{

    public function getAll(array $args = []): Builder
    {
        $query = ClassifiedDelivery::query();

        if (!empty($args['search'])) {
            $query->where(function($q) use ($args) {
                $q->where('name', 'like', '%' . $args['search'] . '%')
                    ->orWhere('description', 'like', '%' . $args['search'] . '%');
            });
        }

        return $query;
    }

    public function find(int $id): ?Model
    {
        return ClassifiedDelivery::find($id);
    }

    public function findBySlug(string $slug): ?ClassifiedDelivery
    {
        return ClassifiedDelivery::where('slug', $slug)->first();
    }

    public function findByUuid(string $uuid): ?ClassifiedDelivery
    {
        return ClassifiedDelivery::where('uuid', $uuid)->first();
    }

    public function getByParentId(string $parentId): Collection
    {
        return ClassifiedDelivery::where('parent_id', $parentId)->get();
    }

    public function getChildDeliveries(string $parentId): Collection
    {
        return ClassifiedDelivery::where('parent_id', $parentId)->get();
    }

    public function create(array $data): Model
    {
        return ClassifiedDelivery::create($data);
    }

    public function update(int $id, array $data): bool
    {
        return ClassifiedDelivery::where('id', $id)->update($data);
    }

    public function updateByUuid(string $uuid, array $data): bool
    {
        return ClassifiedDelivery::where('uuid', $uuid)->update($data);
    }

    public function delete(int $id): bool
    {
        return ClassifiedDelivery::where('id', $id)->delete();
    }
}