<?php

declare(strict_types=1);

namespace App\Repositories\Eloquent\Classified;

use App\Models\Classified\ClassifiedTag;
use App\Repositories\Contracts\Classified\ClassifiedTagRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class ClassifiedTagRepository implements ClassifiedTagRepositoryInterface
{
    public function getAll(array $args = []): Builder
    {
        $query = ClassifiedTag::query();
        
        if (!empty($args['search'])) {
            $query->where(function($q) use ($args) {
                $q->where('name', 'like', '%' . $args['search'] . '%')
                  ->orWhere('description', 'like', '%' . $args['search'] . '%');
            });
        }
        
        return $query;
    }

    public function find(int $id): ?Model
    {
        return ClassifiedTag::find($id);
    }
    
    public function findBySlug(string $slug): ?Model
    {
        return ClassifiedTag::where('slug', $slug)->first();
    }

    public function create(array $data): Model
    {
        return ClassifiedTag::create($data);
    }

    public function update(int $id, array $data): bool
    {
        return ClassifiedTag::find($id)->update($data);
    }

    public function delete(int $id): bool
    {
        return ClassifiedTag::find($id)->delete();
    }
} 