<?php

declare(strict_types=1);

namespace App\Repositories\Eloquent\Classified;

use App\Models\Classified\ClassifiedType;
use App\Repositories\Contracts\Classified\ClassifiedTypeRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class ClassifiedTypeRepository implements ClassifiedTypeRepositoryInterface
{
    public function getAll(array $args = []): Builder
    {
        $query = ClassifiedType::query();
        

        if (!empty($args['search'])) {
            $query->where(function($q) use ($args) {
                $q->where('name', 'like', '%' . $args['search'] . '%')
                  ->orWhere('description', 'like', '%' . $args['search'] . '%');
            });
        }
        
        if(!empty($args['limit'])){
            $query->limit($args['limit']);
        }
        
        return $query;
    }

    public function find(int $id): ?Model
    {
        return ClassifiedType::find($id);
    }
    
    public function findBySlug(string $slug): ?Model
    {
        return ClassifiedType::where('slug', $slug)->first();
    }

    public function create(array $data): Model
    {
        return ClassifiedType::create($data);
    }

    public function update(int $id, array $data): bool
    {
        return ClassifiedType::find($id)->update($data);
    }

    public function delete(int $id): bool
    {
        return ClassifiedType::find($id)->delete();
    }
} 