<?php

namespace App\Repositories\Eloquent\Inquiry;

use App\Repositories\Contracts\Inquiry\InquiryRepositoryInterface;
use App\Repositories\Eloquent\BaseRepository;
use App\Models\User\Inquiry;
use Illuminate\Database\Eloquent\Model;

class InquiryRepository implements InquiryRepositoryInterface
{
    protected $model;

    public function __construct(Inquiry $model)
    {
        $this->model = $model;
    }

    public function getAll(array $args = [])
    {
        $query = $this->model->query();

        if (!empty($args['search'])) {
            $query->where('name', 'like', '%' . $args['search'] . '%');
        }

        return $query;
    }

    public function findById(int $id): ?Model
    {
        return $this->model->find($id);
    }

    public function findByUuid(string $uuid): ?Model
    {
        return $this->model->where('uuid', $uuid)->first();
    }

    public function create(array $data): Model
    {
        return $this->model->create($data);
    }

    public function update(Model $model, array $data): bool
    {
        return $model->update($data);
    }

    public function delete(Model $model): bool
    {
        return $model->delete();
    }
}