<?php

namespace App\Repositories\Eloquent\Job;

use App\Models\Job\JobApplication;
use App\Repositories\Contracts\Job\JobApplicationRepositoryInterface;

class JobApplicationRepository implements JobApplicationRepositoryInterface
{
    public function getAll($args = [])
    {
        $query = JobApplication::query();

        if (!empty($args['job_id'])) {
            $query->where('job_id', $args['job_id']);
        }

        if (!empty($args['applicant_id'])) {
            $query->where('applicant_id', $args['applicant_id']);
        }

        if (!empty($args['application_status'])) {
            $query->where('application_status', $args['application_status']);
        }

        return $query;
    }

    public function find($id)
    {
        return JobApplication::find($id);
    }

    public function findByUuid(string $uuid)
    {
        return JobApplication::where('uuid', $uuid)->first();
    }

    public function create(array $data)
    {
        return JobApplication::create($data);
    }

    public function update($id, array $data)
    {
        $application = JobApplication::find($id);
        $application->update($data);
        return $application;
    }

    public function updateByUuid(string $uuid, array $data)
    {
        $application = JobApplication::where('uuid', $uuid)->firstOrFail();
        $application->update($data);
        return $application;
    }

    public function delete($id)
    {
        return JobApplication::find($id)->delete();
    }

    public function getApplicationsByJob($jobId)
    {
        return JobApplication::where('job_id', $jobId)
            ->with(['applicant'])
            ->latest()
            ->get();
    }

    public function getApplicationsByApplicant($applicantId)
    {
        return JobApplication::where('applicant_id', $applicantId)
            ->with(['job'])
            ->latest()
            ->get();
    }

    public function getApplicationsByStatus($status)
    {
        return JobApplication::where('application_status', $status)
            ->with(['job', 'applicant'])
            ->latest()
            ->get();
    }

    public function updateStatus($id, $status)
    {
        $application = JobApplication::find($id);
        $application->update(['application_status' => $status]);
        return $application;
    }
} 