<?php

namespace App\Repositories\Eloquent\Job;

use App\Models\Job\JobCareerLevel;
use App\Repositories\Contracts\Job\JobCareerLevelRepositoryInterface;

class JobCareerLevelRepository implements JobCareerLevelRepositoryInterface
{
    public function getAll($args = [])
    {
        $query = JobCareerLevel::query();
        
        if (!empty($args['search'])) {
            $query->where(function($q) use ($args) {
                $q->where('career_level_name', 'like', '%' . $args['search'] . '%')
                  ->orWhere('career_level_description', 'like', '%' . $args['search'] . '%');
            });
        }

        if (isset($args['is_active'])) {
            $query->where('is_active', $args['is_active']);
        }

        if (!empty($args['created_by'])) {
            $query->where('created_by', $args['created_by']);
        }

        if (isset($args['parent_id'])) {
            $query->where('parent_id', $args['parent_id']);
        }

        return $query;
    }

    public function find($id)
    {
        return JobCareerLevel::find($id);
    }

    public function findBySlug($slug)
    {
        return JobCareerLevel::where('slug', $slug)->first();
    }

    public function findByUuid(string $uuid)
    {
        return JobCareerLevel::where('uuid', $uuid)->first();
    }

    public function create(array $data)
    {
        return JobCareerLevel::create($data);
    }

    public function update($id, array $data)
    {
        $level = JobCareerLevel::find($id);
        $level->update($data);
        return $level;
    }

    public function updateByUuid(string $uuid, array $data)
    {
        $level = JobCareerLevel::where('uuid', $uuid)->firstOrFail();
        $level->update($data);
        return $level;
    }

    public function delete($id)
    {
        return JobCareerLevel::find($id)->delete();
    }

    public function getActive()
    {
        return JobCareerLevel::where('is_active', true)->get();
    }

    public function getParentLevels()
    {
        return JobCareerLevel::whereNull('parent_id')
            ->where('is_active', true)
            ->get();
    }

    public function getChildLevels($parentId)
    {
        return JobCareerLevel::where('parent_id', $parentId)
            ->where('is_active', true)
            ->get();
    }
} 