<?php

namespace App\Repositories\Eloquent\Job;

use App\Models\Job\JobIndustry;
use App\Repositories\Contracts\Job\JobIndustryRepositoryInterface;

class JobIndustryRepository implements JobIndustryRepositoryInterface
{
    public function getAll($args = [])
    {
        $query = JobIndustry::query();
        
        if (!empty($args['search'])) {
            $query->where(function($q) use ($args) {
                $q->where('industry_name', 'like', '%' . $args['search'] . '%')
                  ->orWhere('industry_description', 'like', '%' . $args['search'] . '%');
            });
        }

        if (isset($args['is_active'])) {
            $query->where('is_active', $args['is_active']);
        }

        if (!empty($args['created_by'])) {
            $query->where('created_by', $args['created_by']);
        }

        return $query;
    }

    public function find($id)
    {
        return JobIndustry::find($id);
    }

    public function findBySlug($slug)
    {
        return JobIndustry::where('slug', $slug)->first();
    }

    public function findByUuid(string $uuid)
    {
        return JobIndustry::where('uuid', $uuid)->first();
    }

    public function create(array $data)
    {
        return JobIndustry::create($data);
    }

    public function update($id, array $data)
    {
        $industry = JobIndustry::find($id);
        $industry->update($data);
        return $industry;
    }

    public function updateByUuid(string $uuid, array $data)
    {
        $industry = JobIndustry::where('uuid', $uuid)->firstOrFail();
        $industry->update($data);
        return $industry;
    }

    public function delete($id)
    {
        return JobIndustry::find($id)->delete();
    }

    public function getActive()
    {
        return JobIndustry::where('is_active', true)->get();
    }

    public function getPopularIndustries($limit = 10)
    {
        return JobIndustry::withCount('jobs')
            ->where('is_active', true)
            ->orderBy('jobs_count', 'desc')
            ->limit($limit)
            ->get();
    }
} 