<?php

namespace App\Repositories\Eloquent\Job;

use App\Models\Job\JobRole;
use App\Repositories\Contracts\Job\JobRoleRepositoryInterface;

class JobRoleRepository implements JobRoleRepositoryInterface
{
    public function getAll($args = [])
    {
        $query = JobRole::query();
        
        if (!empty($args['search'])) {
            $query->where(function($q) use ($args) {
                $q->where('job_role_name', 'like', '%' . $args['search'] . '%')
                  ->orWhere('job_role_description', 'like', '%' . $args['search'] . '%');
            });
        }

        if (isset($args['is_active'])) {
            $query->where('is_active', $args['is_active']);
        }

        if (!empty($args['created_by'])) {
            $query->where('created_by', $args['created_by']);
        }

        return $query;
    }

    public function find($id)
    {
        return JobRole::find($id);
    }

    public function findBySlug($slug)
    {
        return JobRole::where('slug', $slug)->first();
    }

    public function findByUuid(string $uuid)
    {
        return JobRole::where('uuid', $uuid)->first();
    }

    public function create(array $data)
    {
        return JobRole::create($data);
    }

    public function update($id, array $data)
    {
        $role = JobRole::find($id);
        $role->update($data);
        return $role;
    }

    public function updateByUuid(string $uuid, array $data)
    {
        $role = JobRole::where('uuid', $uuid)->firstOrFail();
        $role->update($data);
        return $role;
    }

    public function delete($id)
    {
        return JobRole::find($id)->delete();
    }

    public function getActive()
    {
        return JobRole::where('is_active', true)->get();
    }
} 