<?php

namespace App\Repositories\Eloquent\Job;

use App\Models\Job\JobType;
use App\Repositories\Contracts\Job\JobTypeRepositoryInterface;

class JobTypeRepository implements JobTypeRepositoryInterface
{
    public function getAll($args = [])
    {
        $query = JobType::query();
        
        if (!empty($args['search'])) {
            $query->where(function($q) use ($args) {
                $q->where('job_type_name', 'like', '%' . $args['search'] . '%')
                  ->orWhere('job_type_description', 'like', '%' . $args['search'] . '%');
            });
        }

        if (isset($args['is_active'])) {
            $query->where('is_active', $args['is_active']);
        }

        if (!empty($args['created_by'])) {
            $query->where('created_by', $args['created_by']);
        }

        if (isset($args['parent_id'])) {
            $query->where('parent_id', $args['parent_id']);
        }

        return $query;
    }

    public function find($id)
    {
        return JobType::find($id);
    }

    public function findBySlug($slug)
    {
        return JobType::where('slug', $slug)->first();
    }

    public function findByUuid(string $uuid)
    {
        return JobType::where('uuid', $uuid)->first();
    }

    public function create(array $data)
    {
        return JobType::create($data);
    }

    public function update($id, array $data)
    {
        $type = JobType::find($id);
        $type->update($data);
        return $type;
    }

    public function updateByUuid(string $uuid, array $data)
    {
        $type = JobType::where('uuid', $uuid)->firstOrFail();
        $type->update($data);
        return $type;
    }

    public function delete($id)
    {
        return JobType::find($id)->delete();
    }

    public function getActive()
    {
        return JobType::where('is_active', true)->get();
    }

    public function getParentTypes()
    {
        return JobType::whereNull('parent_id')
            ->where('is_active', true)
            ->get();
    }

    public function getChildTypes($parentId)
    {
        return JobType::where('parent_id', $parentId)
            ->where('is_active', true)
            ->get();
    }
} 