<?php

namespace App\Repositories\Eloquent\Lead;

use App\Models\Lead\LeadForm;
use App\Repositories\Contracts\Lead\LeadFormFieldRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;

class LeadFormFieldRepository implements LeadFormFieldRepositoryInterface
{
    public function getFormFields(LeadForm $leadForm): Collection
    {
        return $leadForm->formFields;
    }

    public function attachField(LeadForm $leadForm, int $fieldId, array $pivotData): void
    {
        $leadForm->formFields()->attach($fieldId, $pivotData);
    }

    public function updateFieldPivot(LeadForm $leadForm, int $fieldId, array $pivotData): void
    {
        $leadForm->formFields()->updateExistingPivot($fieldId, $pivotData);
    }

    public function detachField(LeadForm $leadForm, int $fieldId): int
    {
        return $leadForm->formFields()->detach($fieldId);
    }
}
