<?php

namespace App\Repositories\Eloquent\Lead;

use App\Models\Lead\LeadForm;
use App\Models\Lead\LeadFormVisit;
use App\Repositories\Contracts\Lead\LeadFormVisitRepositoryInterface;

class LeadFormVisitRepository implements LeadFormVisitRepositoryInterface
{
    public function create(LeadForm $leadForm, array $data): LeadFormVisit
    {
        return $leadForm->visits()->create($data);
    }

    public function findByUuid(string $uuid): ?LeadFormVisit
    {
        return LeadFormVisit::where('uuid', $uuid)->first();
    }

    public function findByUuidOrFail(string $uuid, array $with = []): LeadFormVisit
    {
        $query = LeadFormVisit::where('uuid', $uuid);

        if (!empty($with)) {
            $query->with($with);
        }

        return $query->firstOrFail();
    }

    public function update(LeadFormVisit $visit, array $data): LeadFormVisit
    {
        $visit->update($data);
        return $visit->fresh();
    }

    public function delete(LeadFormVisit $visit): bool
    {
        return $visit->delete();
    }
}
