<?php

namespace App\Repositories\Eloquent\Location;

use App\Models\Location\Country;
use App\Repositories\Contracts\Location\CountryRepositoryInterface;

class CountryRepository implements CountryRepositoryInterface
{
    public function getAll(array $args = [])
    {
        $query = Country::query();

        if (!empty($args['search'])) {
            $query->where(function ($q) use ($args) {
                $q->where('country_name', 'like', '%' . $args['search'] . '%')
                    ->orWhere('country_code', 'like', '%' . $args['search'] . '%');
            });
        }


        if (! empty($args['created_by'])) {
            $query->where('created_by', $args['created_by']);
        }

        return $query;
    }

    public function find($id)
    {
        return Country::find($id);
    }

    public function findBySlug(string $slug)
    {
        return Country::where('slug', $slug)->first();
    }

    public function findByUuid(string $uuid)
    {
        return Country::where('uuid', $uuid)->first();
    }

    public function create(array $data)
    {
        return Country::create($data);
    }

    public function update($id, array $data)
    {
        $country = Country::find($id);
        if ($country) {
            $country->update($data);
        }
        return $country;
    }

    public function updateByUuid(string $uuid, array $data)
    {
        $country = Country::where('uuid', $uuid)->firstOrFail();
        $country->update($data);
        return $country;
    }

    public function delete($id)
    {
        return Country::find($id)?->delete();
    }

    public function findOrCreateByCodeAndName(string $code, string $name)
    {
        return Country::firstOrCreate(
            ['country_code' => $code],
            ['country_name' => $name]
        );
    }
}
