<?php

namespace App\Repositories\Eloquent\Location;

use App\Models\Location\State;
use App\Repositories\Contracts\Location\StateRepositoryInterface;

class StateRepository implements StateRepositoryInterface
{
    public function getAll(array $args = [])
    {
        $query = State::query();
        if (!empty($args['search'])) {
            $query->where('state_name', 'like', '%' . $args['search'] . '%');
        }
        if (!empty($args['country_id'])) {
            $query->where('country_id', $args['country_id']);
        }
        return $query;
    }
    public function find($id)
    {
        return State::find($id);
    }
    public function findBySlug(string $slug)
    {
        return State::where('slug', $slug)->first();
    }
    public function findByUuid(string $uuid)
    {
        return State::where('uuid', $uuid)->first();
    }
    public function create(array $data)
    {
        return State::create($data);
    }
    public function update($id, array $data)
    {
        return State::find($id)->update($data);
    }
    public function delete($id)
    {
        return State::find($id)->delete();
    }

    public function findOrCreateByNameAndCountry(string $name, int $countryId, ?string $code = null)
    {
        // First try to find by name and country
        $state = State::where('state_name', $name)
            ->where('country_id', $countryId)
            ->first();
        
        if (!$state) {
            $state = State::create([
                'state_name' => $name,
                'state_code' => $code,
                'country_id' => $countryId
            ]);
        }
        
        return $state;
    }
}
