<?php

declare(strict_types=1);

namespace App\Repositories\Eloquent\Product;

use App\Models\Product\ProductCategory;
use App\Repositories\Contracts\Product\ProductCategoryRepositoryInterface;

class ProductCategoryRepository implements ProductCategoryRepositoryInterface
{
    public function getAll(array $args = [])
    {
        $query = ProductCategory::query();
        
        if (!empty($args['search'])) {
            $query->where(function($q) use ($args) {
                $q->where('product_category_name', 'like', '%' . $args['search'] . '%')
                  ->orWhere('product_category_description', 'like', '%' . $args['search'] . '%');
            });
        }

        if (!empty($args['is_active'])) {
            $query->where('is_active', $args['is_active']);
        }

        if (!empty($args['created_by'])) {
            $query->where('created_by', $args['created_by']);
        }

        return $query;
    }

    public function find($id)
    {
        return ProductCategory::find($id);
    }

    public function findBySlug(string $slug)
    {
        return ProductCategory::where('slug', $slug)->first();
    }

    public function findByUuid(string $uuid)
    {
        return ProductCategory::where('uuid', $uuid)->first();
    }

    public function create(array $data)
    {
        return ProductCategory::create($data);
    }

    public function update($id, array $data)
    {
        $category = ProductCategory::find($id);
        if ($category) {
            $category->update($data);
        }
        return $category;
    }

    public function updateByUuid(string $uuid, array $data)
    {
        $category = ProductCategory::where('uuid', $uuid)->firstOrFail();
        $category->update($data);
        return $category;
    }

    public function delete($id)
    {
        return ProductCategory::find($id)?->delete();
    }

    public function getActive()
    {
        return ProductCategory::active();
    }

    public function getChildCategories($parentId)
    {
        return ProductCategory::where('parent_id', $parentId)->get();
    }

    public function getCategoryProducts($categoryId)
    {
        return ProductCategory::find($categoryId)?->products;
    }
} 