<?php

namespace App\Repositories\Eloquent\Settings;

use App\Models\Setting;
use App\Repositories\Contracts\Settings\SettingRepositoryInterface;

class SettingRepository implements SettingRepositoryInterface
{
    protected $model;

    public function __construct(Setting $model)
    {
        $this->model = $model;
    }

    public function findByKey(string $key)
    {
        return $this->model->where('key', $key)->first();
    }

    public function updateOrCreateByKey(string $key, array $data)
    {
        return $this->model->updateOrCreate(
            ['key' => $key],
            $data
        );
    }

    public function getAllSettings()
    {
        return $this->model->pluck('value', 'key');
    }
}
