<?php

declare(strict_types=1);

namespace App\Repositories\Eloquent\User;

use App\Models\User\MemberCategory;
use App\Repositories\Contracts\User\MemberCategoryRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;

class MemberCategoryRepository implements MemberCategoryRepositoryInterface
{
    public function __construct(
        protected MemberCategory $model
    ) {}

    public function getAll(array $args = [])
    {
        $query = $this->model->query();

        if (!empty($args['user_id'])) {
            $query->whereHas('users', function ($q) use ($args) {
                $q->where('user_id', $args['user_id']);
            });
        }

        if (!empty($args['limit'])) {
            $query->limit($args['limit']);
        }
        
        return $query;
    }

    public function getParentCategories(): Collection
    {
        return $this->model->whereNull('parent_id')->get();
    }

    public function findById(string $id): ?MemberCategory
    {
        return $this->model->find($id);
    }

    public function getCategoryBySlug(string $slug): ?MemberCategory
    {
        return $this->model->where('slug', $slug)->first();
    }

    public function getCategoryBySlugs(array $slugs): Collection
    {
        return $this->model->whereIn('slug', $slugs)->get();
    }

    public function getChildCategories(string $parentId): Collection
    {
        return $this->model->where('parent_id', $parentId)->get();
    }

    public function create(array $data): MemberCategory
    {
        return $this->model->create($data);
    }

    public function update(string $id, array $data): bool
    {
        return $this->model->where('id', $id)->update($data);
    }

    public function delete(string $id): bool
    {
        return $this->model->where('id', $id)->delete();
    }

} 