<?php

namespace App\Repositories\Eloquent\User;

use App\Repositories\Contracts\User\MemberPlanRepositoryInterface;
use App\Models\Membership\MembershipPlan;

class MemberPlanRepository implements MemberPlanRepositoryInterface
{
    public function getAll($array = [])
    {
        $query = MembershipPlan::query();

        if (!empty($array['search'])) {
            $query->where('package_title', 'like', '%' . $array['search'] . '%');
        }

        if (!empty($array['limit'])) {
            $query->limit($array['limit']);
        }

        if (!empty($array['is_active'])) {
            $query->where('is_active', $array['is_active']);
        }

        if (!empty($array['order_by'])) {
            $query->orderBy($array['order_by'], $array['order']);

        }
        else {
            $query->orderBy('created_at', 'desc');
        }        

        return $query;
    }

    public function findById(string $id): ?MembershipPlan
    {
        return MembershipPlan::find($id);
    }

    public function create(array $array): MembershipPlan
    {
        return MembershipPlan::create($array);
    }

    public function update(array $array, $id): bool
    {
        return MembershipPlan::find($id)->update($array);
    }

    public function delete($id): bool
    {
        return MembershipPlan::find($id)->delete();
    }

    public function findByUuid($uuid): ?MembershipPlan
    {
        return MembershipPlan::where('uuid', $uuid)->first();
    }

    public function findBySlug(string $slug): ?MembershipPlan
    {
        return MembershipPlan::where('slug', $slug)->first();
    }

    public function findByMembershipType(string $membershipType): ?MembershipPlan
    {
        return MembershipPlan::where('membership_type', $membershipType)->first();
    }
}
