<?php

declare(strict_types=1);

namespace App\Repositories\Eloquent\User;

use App\Models\User\UserLocation;
use App\Repositories\Contracts\User\UserLocationRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;

class UserLocationRepository implements UserLocationRepositoryInterface
{
    public function __construct(
        private UserLocation $model
    ) {}

    public function all(): Collection
    {
        return $this->model->all();
    }

    public function findById(string $id): ?UserLocation
    {
        return $this->model->find($id);
    }

    public function findByUuid(string $uuid): ?UserLocation
    {
        return $this->model->where('uuid', $uuid)->first();
    }

    public function create(array $data): UserLocation
    {
        return $this->model->create($data);
    }

    public function update(UserLocation $userLocation, array $data): bool
    {
        return $userLocation->update($data);
    }

    public function delete(UserLocation $userLocation): bool
    {
        return $userLocation->delete();
    }

    public function getPrimaryLocation(int|string $userId): ?UserLocation
    {
        return $this->model
            ->where('user_id', $userId)
            ->where('primary_location', true)
            ->first();
    }

    public function getActiveLocations(int|string $userId): Collection
    {
        return $this->model
            ->where('user_id', $userId)
            ->where('is_active', true)
            ->orderByDesc('primary_location')
            ->orderBy('created_at', 'desc')
            ->get();
    }
} 