<?php

namespace App\Repositories\Eloquent\User;

use App\Models\Membership\Subscription;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use App\Repositories\Contracts\User\UserSubscriptionRepositoryInterface;
class UserSubscriptionRepository implements UserSubscriptionRepositoryInterface
{

    /**
     * Get all subscriptions
     *
     * @param array $args
     * @return Builder
     */
    public function getAll(array $args = []): Builder
    {
        $query = Subscription::query();



        return $query;
    }

    public function find(int $id): ?Model
    {
        return Subscription::find($id);
    }

    public function findByUuid(string $uuid): ?Model
    {
        return Subscription::where('uuid', $uuid)->first();
    }

    /**
     * Create a new subscription
     *
     * @param array $data
     * @return Subscription
     */
    public function create(array $data): Subscription
    {
        return Subscription::create($data);
    }

    public function update(int $id, array $data): bool
    {
        return Subscription::where('id', $id)->update($data);
    }

    /**
     * Update a subscription
     *
     * @param string $uuid
     * @param array $data
     * @return bool
     */
    public function updateByUuid(string $uuid, array $data): bool
    {
        return Subscription::where('uuid', $uuid)->update($data);
    }

    public function delete(int $id): bool
    {
        return Subscription::where('id', $id)->delete();
    }

    /**
     * Delete a subscription
     *
     * @param string $uuid
     * @return bool
     */
    public function deleteByUuid(string $uuid): bool
    {
        return Subscription::where('uuid', $uuid)->delete();
    }

    public function getByUserId(int $userId): ?Model
    {
        return Subscription::where('user_id', $userId)->first();
    }

    public function findBySlug(string $slug): ?Model
    {
        return Subscription::where('slug', $slug)->first();
    }
}
