<?php

declare(strict_types=1);

namespace App\Repositories\Eloquent\User;

use App\Models\User\UserVideo;
use App\Repositories\Contracts\User\UserVideoRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class UserVideoRepository implements UserVideoRepositoryInterface
{
    public function getAll(array $args = []): Builder
    {
        $query = UserVideo::query();

        if (!empty($args['search'])) {
            $query->where(function ($q) use ($args) {
                $q->where('video_title', 'like', '%' . $args['search'] . '%')
                    ->orWhere('video_description', 'like', '%' . $args['search'] . '%');
            });
        }

        if (isset($args['is_active'])) {
            $query->where('is_active', $args['is_active']);
        }

        if (!empty($args['user_id'])) {
            $query->where('user_id', $args['user_id']);
        }

        return $query;
    }

    public function find(int $id): ?Model
    {
        return UserVideo::find($id);
    }

    public function findByUuid(string $uuid): ?Model
    {
        return UserVideo::where('uuid', $uuid)->first();
    }

    public function findByUserId(int $userId, array $args = []): Builder
    {
        $query = UserVideo::where('user_id', $userId);

        if (isset($args['is_active'])) {
            $query->where('is_active', $args['is_active']);
        }

        if (!empty($args['search'])) {
            $query->where(function ($q) use ($args) {
                $q->where('video_title', 'like', '%' . $args['search'] . '%')
                    ->orWhere('video_description', 'like', '%' . $args['search'] . '%');
            });
        }

        return $query;
    }

    public function create(array $data): Model
    {
        return UserVideo::create($data);
    }

    public function update(int $id, array $data): bool
    {
        return UserVideo::find($id)->update($data);
    }

    public function delete(int $id): bool
    {
        return UserVideo::find($id)->delete();
    }
}
