<?php

declare(strict_types=1);

namespace App\Services\Blog;

use App\Repositories\Contracts\Blog\PostCategoryRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class PostCategoryService
{
    public function __construct(
        protected PostCategoryRepositoryInterface $postCategoryRepository
    ) {}

    public function getAll(array $args = []): Builder
    {
        return $this->postCategoryRepository->getAll($args);
    }

    public function find(int $id): ?Model
    {
        return $this->postCategoryRepository->find($id);
    }

    public function findBySlug(string $slug): ?Model
    {
        return $this->postCategoryRepository->findBySlug($slug);
    }

    public function getBySlug(array $slugs): \Illuminate\Support\Collection
    {
        return $this->postCategoryRepository->getBySlug($slugs);
    }
} 