<?php

declare(strict_types=1);

namespace App\Services\Blog;

use App\Repositories\Contracts\Blog\PostTagRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class PostTagService
{
    public function __construct(
        protected PostTagRepositoryInterface $postTagRepository
    ) {}

    public function getAll(array $args = []): Builder
    {
        return $this->postTagRepository->getAll($args);
    }

    public function find(int $id): ?Model
    {
        return $this->postTagRepository->find($id);
    }

    public function findBySlug(string $slug): ?Model
    {
        return $this->postTagRepository->findBySlug($slug);
    }
} 