<?php

namespace App\Services\Classified;
use App\Repositories\Contracts\Classified\ClassifiedCategoryRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use App\Models\Classified\ClassifiedCategory;
use Illuminate\Database\Eloquent\Collection;

class ClassifiedCategoryService
{   
    public function __construct(protected ClassifiedCategoryRepositoryInterface $classifiedCategoryRepository)
    {}

    public function getAll(array $args = []): Builder
    {
        return $this->classifiedCategoryRepository->getAll($args);
    }

    public function getParentCategories(): Collection
    {
        return $this->classifiedCategoryRepository->getParentCategories();
    }

    public function find(int $id): ?ClassifiedCategory
    {
        return $this->classifiedCategoryRepository->find($id);
    }   

    public function findBySlug(string $slug): ?ClassifiedCategory
    {
        return $this->classifiedCategoryRepository->findBySlug($slug);
    }

    public function getChildCategories(int $parentId): Collection
    {
        return $this->classifiedCategoryRepository->getChildCategories($parentId);
    }

    public function create(array $data): ClassifiedCategory
    {
        return $this->classifiedCategoryRepository->create($data);
    }

    public function update(int $id, array $data): bool
    {
        return $this->classifiedCategoryRepository->update($id, $data);
    }

    public function delete(int $id): bool
    {
        return $this->classifiedCategoryRepository->delete($id);
    }
}