<?php

namespace App\Services\Classified;

use App\Repositories\Contracts\Classified\ClassifiedDeliveryRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

class ClassifiedDeliveryService
{
    public function __construct(
        protected ClassifiedDeliveryRepositoryInterface $classifiedDeliveryRepository
    ) {}

    public function getAll(array $args = [])
    {
        return $this->classifiedDeliveryRepository->getAll($args);
    }

    public function find(int $id): ?Model
    {
        return $this->classifiedDeliveryRepository->find($id);
    }

    public function findBySlug(string $slug): ?Model
    {
        return $this->classifiedDeliveryRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid): ?Model
    {
        return $this->classifiedDeliveryRepository->findByUuid($uuid);
    }

    public function getByParentId(string $parentId): Collection
    {
        return $this->classifiedDeliveryRepository->getByParentId($parentId);
    }

    public function getChildDeliveries(string $parentId): Collection
    {
        return $this->classifiedDeliveryRepository->getChildDeliveries($parentId);
    }

    public function create(array $data): Model
    {
        return $this->classifiedDeliveryRepository->create($data);
    }

    public function update(int $id, array $data): bool
    {
        return $this->classifiedDeliveryRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data): bool
    {
        return $this->classifiedDeliveryRepository->updateByUuid($uuid, $data);
    }

    public function delete(int $id): bool
    {
        return $this->classifiedDeliveryRepository->delete($id);
    }
}
