<?php

namespace App\Services\Classified;

use App\Repositories\Contracts\Classified\ClassifiedTypeRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class ClassifiedTypeService
{


    public function __construct(protected ClassifiedTypeRepositoryInterface $classifiedTypeRepository)
    {}

    public function getAll(array $args = []):Builder
    {
        return $this->classifiedTypeRepository->getAll($args);
    }

    public function find(int $id): ?Model
    {
        return $this->classifiedTypeRepository->find($id);
    }

    public function findBySlug(string $slug): ?Model
    {
        return $this->classifiedTypeRepository->findBySlug($slug);
    }

    public function create(array $data): Model
    {
        return $this->classifiedTypeRepository->create($data);
    }

    public function update(int $id, array $data): bool
    {
        return $this->classifiedTypeRepository->update($id, $data);
    }

    public function delete(int $id): bool
    {
        return $this->classifiedTypeRepository->delete($id);
    }
    
    

}