<?php

namespace App\Services\Equipment;

use App\Repositories\Contracts\Equipment\EquipmentRepositoryInterface;

class EquipmentService
{
    protected $equipmentRepository;

    public function __construct(EquipmentRepositoryInterface $equipmentRepository)
    {
        $this->equipmentRepository = $equipmentRepository;
    }

    public function getAll($args = [])
    {
        return $this->equipmentRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->equipmentRepository->find($id);
    }

    public function findBySlug($slug)
    {
        return $this->equipmentRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid)
    {
        return $this->equipmentRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->equipmentRepository->create($data);
    }

    public function update($id, array $data)
    {
        return $this->equipmentRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data)
    {
        return $this->equipmentRepository->updateByUuid($uuid, $data);
    }

    public function delete($id)
    {
        return $this->equipmentRepository->delete($id);
    }

    public function getFeaturedEquipment($args = [])
    {
        return $this->equipmentRepository->getFeaturedEquipment($args);
    }

    public function getRelatedEquipment($args = [])
    {
        return $this->equipmentRepository->getRelatedEquipment($args);
    }
} 