<?php

namespace App\Services\Inquiry;

use App\Repositories\Contracts\Inquiry\InquiryRepositoryInterface;
use Illuminate\Database\Eloquent\Model;
class InquiryService
{
    protected $inquiryRepository;

    public function __construct(InquiryRepositoryInterface $inquiryRepository)
    {
        $this->inquiryRepository = $inquiryRepository;
    }

    public function getAll(array $args = [])
    {
        return $this->inquiryRepository->getAll($args);
    }

    public function findById(int $id): ?Model
    {
        return $this->inquiryRepository->findById($id);
    }

    public function findByUuid(string $uuid): ?Model
    {
        return $this->inquiryRepository->findByUuid($uuid);
    }
    
    public function create(array $data): Model
    {
        return $this->inquiryRepository->create($data);
    }

    public function update(Model $model, array $data): bool
    {
        return $this->inquiryRepository->update($model, $data);
    }
}