<?php

namespace App\Services\Job;

use App\Repositories\Contracts\Job\JobApplicationRepositoryInterface;

class JobApplicationService
{
    protected $jobApplicationRepository;

    public function __construct(JobApplicationRepositoryInterface $jobApplicationRepository)
    {
        $this->jobApplicationRepository = $jobApplicationRepository;
    }

    public function getAll($args = [])
    {
        return $this->jobApplicationRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->jobApplicationRepository->find($id);
    }

    public function findByUuid(string $uuid)
    {
        return $this->jobApplicationRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->jobApplicationRepository->create($data);
    }

    public function update($id, array $data)
    {
        return $this->jobApplicationRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data)
    {
        return $this->jobApplicationRepository->updateByUuid($uuid, $data);
    }

    public function delete($id)
    {
        return $this->jobApplicationRepository->delete($id);
    }

    public function getApplicationsByJob($jobId)
    {
        return $this->jobApplicationRepository->getApplicationsByJob($jobId);
    }

    public function getApplicationsByApplicant($applicantId)
    {
        return $this->jobApplicationRepository->getApplicationsByApplicant($applicantId);
    }

    public function getApplicationsByStatus($status)
    {
        return $this->jobApplicationRepository->getApplicationsByStatus($status);
    }

    public function updateStatus($id, $status)
    {
        return $this->jobApplicationRepository->updateStatus($id, $status);
    }
} 