<?php

namespace App\Services\Job;

use App\Repositories\Contracts\Job\JobCareerLevelRepositoryInterface;

class JobCareerLevelService
{
    protected $jobCareerLevelRepository;

    public function __construct(JobCareerLevelRepositoryInterface $jobCareerLevelRepository)
    {
        $this->jobCareerLevelRepository = $jobCareerLevelRepository;
    }

    public function getAll($args = [])
    {
        return $this->jobCareerLevelRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->jobCareerLevelRepository->find($id);
    }

    public function findBySlug($slug)
    {
        return $this->jobCareerLevelRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid)
    {
        return $this->jobCareerLevelRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->jobCareerLevelRepository->create($data);
    }

    public function update($id, array $data)
    {
        return $this->jobCareerLevelRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data)
    {
        return $this->jobCareerLevelRepository->updateByUuid($uuid, $data);
    }

    public function delete($id)
    {
        return $this->jobCareerLevelRepository->delete($id);
    }

    public function getActive()
    {
        return $this->jobCareerLevelRepository->getActive();
    }

    public function getParentLevels()
    {
        return $this->jobCareerLevelRepository->getParentLevels();
    }

    public function getChildLevels($parentId)
    {
        return $this->jobCareerLevelRepository->getChildLevels($parentId);
    }
} 