<?php

namespace App\Services\Job;

use App\Repositories\Contracts\Job\JobIndustryRepositoryInterface;

class JobIndustryService
{
    protected $jobIndustryRepository;

    public function __construct(JobIndustryRepositoryInterface $jobIndustryRepository)
    {
        $this->jobIndustryRepository = $jobIndustryRepository;
    }

    public function getAll($args = [])
    {
        return $this->jobIndustryRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->jobIndustryRepository->find($id);
    }

    public function findBySlug($slug)
    {
        return $this->jobIndustryRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid)
    {
        return $this->jobIndustryRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->jobIndustryRepository->create($data);
    }

    public function update($id, array $data)
    {
        return $this->jobIndustryRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data)
    {
        return $this->jobIndustryRepository->updateByUuid($uuid, $data);
    }

    public function delete($id)
    {
        return $this->jobIndustryRepository->delete($id);
    }

    public function getActive()
    {
        return $this->jobIndustryRepository->getActive();
    }

    public function getPopularIndustries($limit = 10)
    {
        return $this->jobIndustryRepository->getPopularIndustries($limit);
    }
} 