<?php

namespace App\Services\Job;

use App\Repositories\Contracts\Job\JobRoleRepositoryInterface;

class JobRoleService
{
    protected $jobRoleRepository;

    public function __construct(JobRoleRepositoryInterface $jobRoleRepository)
    {
        $this->jobRoleRepository = $jobRoleRepository;
    }

    public function getAll($args = [])
    {
        return $this->jobRoleRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->jobRoleRepository->find($id);
    }

    public function findBySlug($slug)
    {
        return $this->jobRoleRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid)
    {
        return $this->jobRoleRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->jobRoleRepository->create($data);
    }

    public function update($id, array $data)
    {
        return $this->jobRoleRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data)
    {
        return $this->jobRoleRepository->updateByUuid($uuid, $data);
    }

    public function delete($id)
    {
        return $this->jobRoleRepository->delete($id);
    }

    public function getActive()
    {
        return $this->jobRoleRepository->getActive();
    }
}
