<?php

namespace App\Services\Job;

use App\Repositories\Contracts\Job\JobSkillRepositoryInterface;

class JobSkillService
{
    protected $jobSkillRepository;

    public function __construct(JobSkillRepositoryInterface $jobSkillRepository)
    {
        $this->jobSkillRepository = $jobSkillRepository;
    }

    public function getAll($args = [])
    {
        return $this->jobSkillRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->jobSkillRepository->find($id);
    }

    public function findBySlug($slug)
    {
        return $this->jobSkillRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid)
    {
        return $this->jobSkillRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->jobSkillRepository->create($data);
    }

    public function update($id, array $data)
    {
        return $this->jobSkillRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data)
    {
        return $this->jobSkillRepository->updateByUuid($uuid, $data);
    }

    public function delete($id)
    {
        return $this->jobSkillRepository->delete($id);
    }

    public function getActive()
    {
        return $this->jobSkillRepository->getActive();
    }

    public function getPopularSkills($limit = 10)
    {
        return $this->jobSkillRepository->getPopularSkills($limit);
    }

    public function attachToJob($jobId, array $skillIds)
    {
        return $this->jobSkillRepository->attachToJob($jobId, $skillIds);
    }

    public function detachFromJob($jobId, array $skillIds)
    {
        return $this->jobSkillRepository->detachFromJob($jobId, $skillIds);
    }
} 