<?php

namespace App\Services\Job;

use App\Repositories\Contracts\Job\JobTypeRepositoryInterface;

class JobTypeService
{
    protected $jobTypeRepository;

    public function __construct(JobTypeRepositoryInterface $jobTypeRepository)
    {
        $this->jobTypeRepository = $jobTypeRepository;
    }

    public function getAll($args = [])
    {
        return $this->jobTypeRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->jobTypeRepository->find($id);
    }

    public function findBySlug($slug)
    {
        return $this->jobTypeRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid)
    {
        return $this->jobTypeRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->jobTypeRepository->create($data);
    }

    public function update($id, array $data)
    {
        return $this->jobTypeRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data)
    {
        return $this->jobTypeRepository->updateByUuid($uuid, $data);
    }

    public function delete($id)
    {
        return $this->jobTypeRepository->delete($id);
    }

    public function getActive()
    {
        return $this->jobTypeRepository->getActive();
    }

    public function getParentTypes()
    {
        return $this->jobTypeRepository->getParentTypes();
    }

    public function getChildTypes($parentId)
    {
        return $this->jobTypeRepository->getChildTypes($parentId);
    }
} 