<?php

namespace App\Services\Lead;

use App\Models\Lead\LeadForm;
use Illuminate\Database\Eloquent\Collection;

class LeadFormFieldService
{
    /**
     * Get form fields with pivot data
     */
    public function getFormFields(string $formUuid): Collection
    {
        $leadForm = LeadForm::where('uuid', $formUuid)
            ->with('formFields')
            ->firstOrFail();

        return $leadForm->formFields;
    }

    /**
     * Attach field to form
     */
    public function attachField(string $formUuid, int $fieldId, array $pivotData): Collection
    {
        $leadForm = LeadForm::where('uuid', $formUuid)->firstOrFail();

        $leadForm->formFields()->attach($fieldId, $pivotData);

        return $leadForm->load('formFields')->formFields;
    }

    /**
     * Update field configuration
     */
    public function updateFieldConfiguration(string $formUuid, int $fieldId, array $pivotData): Collection
    {
        $leadForm = LeadForm::where('uuid', $formUuid)->firstOrFail();

        $leadForm->formFields()->updateExistingPivot($fieldId, $pivotData);

        return $leadForm->load('formFields')->formFields;
    }

    /**
     * Detach field from form
     */
    public function detachField(string $formUuid, int $fieldId): bool
    {
        $leadForm = LeadForm::where('uuid', $formUuid)->firstOrFail();

        return (bool) $leadForm->formFields()->detach($fieldId);
    }
}
