<?php

namespace App\Services\Location;

use App\Repositories\Contracts\Location\CityRepositoryInterface;

class CityService
{
    public function __construct(
        protected CityRepositoryInterface $cityRepository
    ) {}

    public function getAll(array $args = [])
    {
        return $this->cityRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->cityRepository->find($id);
    }

    public function findBySlug(string $slug)
    {
        return $this->cityRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid)
    {
        return $this->cityRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->cityRepository->create($data);
    }

    public function update(string $id, array $data)
    {
        return $this->cityRepository->update($id, $data);
    }

    public function delete(string $id)
    {
        return $this->cityRepository->delete($id);
    }

    public function getCityBySlug(string $slug)
    {
        return $this->cityRepository->findBySlug($slug);
    }

    public function getCityById($id)
    {
        return $this->cityRepository->find($id);
    }

    public function getCityByUuid(string $uuid)
    {
        return $this->cityRepository->findByUuid($uuid);
    }

    public function findOrCreateByNameAndState(string $name, int $stateId, int $countryId)
    {
        return $this->cityRepository->findOrCreateByNameAndState($name, $stateId, $countryId);
    }
}
