<?php

namespace App\Services\Location;

use App\Repositories\Contracts\Location\CountryRepositoryInterface;

class CountryService
{
    public function __construct(
        protected CountryRepositoryInterface $countryRepository
    ) {}

    public function getAll(array $args = [])
    {
        return $this->countryRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->countryRepository->find($id);
    }

    public function findBySlug(string $slug)
    {
        return $this->countryRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid)
    {
        return $this->countryRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->countryRepository->create($data);
    }

    public function update(string $id, array $data)
    {
        return $this->countryRepository->update($id, $data);
    }

    public function delete(string $id)
    {
        return $this->countryRepository->delete($id);
    }

    public function getCountryBySlug(string $slug)
    {
        return $this->countryRepository->findBySlug($slug);
    }

    public function findOrCreateByCodeAndName(string $code, string $name)
    {
        return $this->countryRepository->findOrCreateByCodeAndName($code, $name);
    }
}
