<?php

namespace App\Services\Location;

use App\Repositories\Contracts\Location\StateRepositoryInterface;

class StateService
{
    protected $stateRepository;

    public function __construct(StateRepositoryInterface $stateRepository)
    {
        $this->stateRepository = $stateRepository;
    }

    public function getAll($countryId)
    {
        return $this->stateRepository->getAll($countryId);
    }
    public function getStateBySlug($slug)
    {
        return $this->stateRepository->findBySlug($slug);
    }
    public function getStateById($id)
    {
        return $this->stateRepository->find($id);
    }
    public function getStateByUuid($uuid)
    {
        return $this->stateRepository->findByUuid($uuid);
    }
    public function createState($data)
    {
        return $this->stateRepository->create($data);
    }
    public function updateState($id, $data)
    {
        return $this->stateRepository->update($id, $data);
    }
    public function deleteState($id)
    {
        return $this->stateRepository->delete($id);
    }

    public function findOrCreateByNameAndCountry(string $name, int $countryId, ?string $code = null)
    {
        return $this->stateRepository->findOrCreateByNameAndCountry($name, $countryId, $code);
    }
}
