<?php

declare(strict_types=1);

namespace App\Services\Payment;

use App\Models\User\User;
use App\Models\Membership\Payment;
use App\Models\Membership\Purchase;
use App\Repositories\Contracts\Payment\PaymentRepositoryInterface;
use App\Enums\PaymentStatus;
use App\Enums\PaymentType;

class PaymentService
{
    public function __construct(
        private PaymentRepositoryInterface $paymentRepository
    ) {}

    /**
     * Create a payment record
     */
    public function createPayment(
        User $user,
        Purchase $purchase,
        string $paymentMethod,
        float $amount,
        string $currency,
        array $metadata = []
    ): Payment {
        return $this->paymentRepository->createPayment(
            $user,
            $purchase,
            $paymentMethod,
            $amount,
            $currency,
            $metadata
        );
    }

    /**
     * Update payment status
     */
    public function updatePaymentStatus(Payment $payment, string $status, array $metadata = []): bool
    {
        return $this->paymentRepository->updatePaymentStatus($payment, $status, $metadata);
    }

    /**
     * Find payment by transaction ID
     */
    public function findByTransactionId(string $transactionId): ?Payment
    {
        return $this->paymentRepository->findByTransactionId($transactionId);
    }
}
