<?php

declare(strict_types=1);

namespace App\Services\Product;

use App\Repositories\Contracts\Product\ProductCategoryRepositoryInterface;

class ProductCategoryService
{
    protected $productCategoryRepository;

    public function __construct(ProductCategoryRepositoryInterface $productCategoryRepository)
    {
        $this->productCategoryRepository = $productCategoryRepository;
    }

    public function getAll(array $args = [])
    {
        return $this->productCategoryRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->productCategoryRepository->find($id);
    }

    public function findBySlug(string $slug)
    {
        return $this->productCategoryRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid)
    {
        return $this->productCategoryRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->productCategoryRepository->create($data);
    }

    public function update($id, array $data)
    {
        return $this->productCategoryRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data)
    {
        return $this->productCategoryRepository->updateByUuid($uuid, $data);
    }

    public function delete($id)
    {
        return $this->productCategoryRepository->delete($id);
    }

    public function getActive()
    {
        return $this->productCategoryRepository->getActive();
    }

    public function getChildCategories($parentId)
    {
        return $this->productCategoryRepository->getChildCategories($parentId);
    }

    public function getCategoryProducts($categoryId)
    {
        return $this->productCategoryRepository->getCategoryProducts($categoryId);
    }
} 