<?php

declare(strict_types=1);

namespace App\Services\Product;

use App\Repositories\Contracts\Product\ProductRepositoryInterface;

class ProductService
{
    protected $productRepository;

    public function __construct(ProductRepositoryInterface $productRepository)
    {
        $this->productRepository = $productRepository;
    }

    public function getAll(array $args = [])
    {
        return $this->productRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->productRepository->find($id);
    }

    public function findBySlug(string $slug)
    {
        return $this->productRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid)
    {
        return $this->productRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->productRepository->create($data);
    }

    public function update($id, array $data)
    {
        return $this->productRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data)
    {
        return $this->productRepository->updateByUuid($uuid, $data);
    }

    public function delete($id)
    {
        return $this->productRepository->delete($id);
    }

    public function getPublished()
    {
        return $this->productRepository->getPublished();
    }

    public function getChildProducts($parentId)
    {
        return $this->productRepository->getChildProducts($parentId);
    }

    public function getProductsByCategory($categoryId)
    {
        return $this->productRepository->getProductsByCategory($categoryId);
    }
} 