<?php

declare(strict_types=1);

namespace App\Services\Project;

use App\Repositories\Contracts\Project\ProjectRepositoryInterface;

class ProjectService
{
    protected $projectRepository;

    public function __construct(ProjectRepositoryInterface $projectRepository)
    {
        $this->projectRepository = $projectRepository;
    }

    public function getAll(array $args = [])
    {
        return $this->projectRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->projectRepository->find($id);
    }

    public function findBySlug(string $slug)
    {
        return $this->projectRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid)
    {
        return $this->projectRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->projectRepository->create($data);
    }

    public function update($id, array $data)
    {
        return $this->projectRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data)
    {
        return $this->projectRepository->updateByUuid($uuid, $data);
    }

    public function delete($id)
    {
        return $this->projectRepository->delete($id);
    }

    public function getRelatedProjects(array $args = [])
    {
        return $this->projectRepository->getRelatedProjects($args);
    }

    public function getFeaturedProjects(array $args = [])
    {
        return $this->projectRepository->getFeaturedProjects($args);
    }

    public function getRelatedProjectsByProjectId(int $projectId, int $limit = 3)
    {
        return $this->projectRepository->getRelatedProjectsByProjectId($projectId, $limit);
    }
}
