<?php

declare(strict_types=1);

namespace App\Services\Team;

use App\Repositories\Contracts\Team\TeamMemberRepositoryInterface;

class TeamMemberService
{
    protected $teamMemberRepository;

    public function __construct(TeamMemberRepositoryInterface $teamMemberRepository)
    {
        $this->teamMemberRepository = $teamMemberRepository;
    }

    public function getAll(array $args = [])
    {
        return $this->teamMemberRepository->getAll($args);
    }

    public function find($id)
    {
        return $this->teamMemberRepository->find($id);
    }

    public function findBySlug(string $slug)
    {
        return $this->teamMemberRepository->findBySlug($slug);
    }

    public function findByUuid(string $uuid)
    {
        return $this->teamMemberRepository->findByUuid($uuid);
    }

    public function create(array $data)
    {
        return $this->teamMemberRepository->create($data);
    }

    public function update($id, array $data)
    {
        return $this->teamMemberRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data)
    {
        return $this->teamMemberRepository->updateByUuid($uuid, $data);
    }

    public function delete($id)
    {
        return $this->teamMemberRepository->delete($id);
    }

    public function getTeamMembers(array $args = [])
    {
        return $this->teamMemberRepository->getTeamMembers($args);
    }

    public function getFeaturedMembers(array $args = [])
    {
        return $this->teamMemberRepository->getFeaturedMembers($args);
    }
}
