<?php

declare(strict_types=1);

namespace App\Services\User;

use App\Repositories\Contracts\User\InquiryRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class InquiryService
{
    public function __construct(
        protected InquiryRepositoryInterface $inquiryRepository
    ) {}

    public function getAll(array $args = []): Builder
    {
        return $this->inquiryRepository->getAll($args);
    }

    public function find(int $id): ?Model
    {
        return $this->inquiryRepository->find($id);
    }

    public function findByUuid(string $uuid): ?Model
    {
        return $this->inquiryRepository->findByUuid($uuid);
    }

    public function create(array $data): Model
    {
        return $this->inquiryRepository->create($data);
    }

    public function update(int $id, array $data): bool
    {
        return $this->inquiryRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data): bool
    {
        return $this->inquiryRepository->updateByUuid($uuid, $data);
    }

    public function delete(int $id): bool
    {
        return $this->inquiryRepository->delete($id);
    }

    public function getByStatus(string $status): Builder
    {
        return $this->inquiryRepository->getByStatus($status);
    }

    public function getByType(string $type): Builder
    {
        return $this->inquiryRepository->getByType($type);
    }

    public function getByInquiryable(string $type, int $id): Builder
    {
        return $this->inquiryRepository->getByInquiryable($type, $id);
    }

    public function getByContact(int $contactId): Builder
    {
        return $this->inquiryRepository->getByContact($contactId);
    }

    public function createInquiryWithContact(array $inquiryData, array $contactData): Model
    {
        // Create or find existing contact
        $contact = \App\Models\User\Contact::firstOrCreate(
            ['email' => $contactData['email']],
            $contactData
        );

        // Create inquiry linked to contact
        $inquiryData['contact_id'] = $contact->id;

        return $this->create($inquiryData);
    }
}
