<?php

declare(strict_types=1);

namespace App\Services\User;

use App\Repositories\Contracts\User\MemberCategoryRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;
use App\Models\User\MemberCategory;

class MemberCategoryService
{
    public function __construct(
        protected MemberCategoryRepositoryInterface $memberCategoryRepository
    ) {}

    public function getAll(array $args = [])
    {
        return $this->memberCategoryRepository->getAll($args);
    }

    public function getParentCategories(): Collection
    {
        return $this->memberCategoryRepository->getParentCategories();
    }

    public function getChildCategories(string $parentId): Collection
    {
        return $this->memberCategoryRepository->getChildCategories($parentId);
    }

    public function findById(string $id): ?MemberCategory
    {
        return $this->memberCategoryRepository->findById($id);
    }

    public function create(array $data): MemberCategory
    {
        return $this->memberCategoryRepository->create($data);
    }

    public function update(string $id, array $data): bool
    {
        return $this->memberCategoryRepository->update($id, $data);
    }

    public function delete(string $id): bool
    {
        return $this->memberCategoryRepository->delete($id);
    }

    public function getCategoryBySlug(string $slug): ?MemberCategory
    {
        return $this->memberCategoryRepository->getCategoryBySlug($slug);
    }
}
