<?php

namespace App\Services\User;

use App\Repositories\Contracts\User\MemberPlanRepositoryInterface;
use App\Models\Membership\MembershipPlan;

class MemberPlanService
{
    protected $memberPlanRepository;

    public function __construct(MemberPlanRepositoryInterface $memberPlanRepository)
    {
        $this->memberPlanRepository = $memberPlanRepository;
    }

    public function getAll($array = [])
    {
        return $this->memberPlanRepository->getAll($array);
    }

    public function findById(string $id): ?MembershipPlan
    {
        return $this->memberPlanRepository->findById($id);
    }

    public function create(array $array): MembershipPlan
    {
        return $this->memberPlanRepository->create($array);
    }

    public function update(array $array, $id): bool
    {
        return $this->memberPlanRepository->update($array, $id);
    }       

    public function delete(string $id): bool
    {
        return $this->memberPlanRepository->delete($id);
    }

    public function findByUuid(string $uuid): ?MembershipPlan
    {
        return $this->memberPlanRepository->findByUuid($uuid);
    }

    public function findBySlug(string $slug): ?MembershipPlan
    {
        return $this->memberPlanRepository->findBySlug($slug);
    }
    
    public function findByMembershipType(string $membershipType): ?MembershipPlan
    {
        return $this->memberPlanRepository->findByMembershipType($membershipType);
    }
}