<?php

declare(strict_types=1);

namespace App\Services\User;

use App\Repositories\Contracts\User\UserServiceRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class UserServiceService
{
    public function __construct(
        protected UserServiceRepositoryInterface $userServiceRepository
    ) {}

    public function getAll(array $args = []): Builder
    {
        return $this->userServiceRepository->getAll($args);
    }

    public function find(int $id): ?Model
    {
        return $this->userServiceRepository->find($id);
    }

    public function findByUuid(string $uuid): ?Model
    {
        return $this->userServiceRepository->findByUuid($uuid);
    }

    public function create(array $data): Model
    {
        return $this->userServiceRepository->create($data);
    }

    public function update(int $id, array $data): bool
    {
        return $this->userServiceRepository->update($id, $data);
    }

    public function updateByUuid(string $uuid, array $data): bool
    {
        return $this->userServiceRepository->updateByUuid($uuid, $data);
    }

    public function delete(int $id): bool
    {
        return $this->userServiceRepository->delete($id);
    }

    public function getUserServices(int $userId): Builder
    {
        return $this->userServiceRepository->getUserServices($userId);
    }
}
