<?php

namespace App\Services\User;

use App\Repositories\Contracts\User\UserSubscriptionRepositoryInterface;
use App\Models\Membership\Subscription;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use App\Repositories\Contracts\User\MemberPlanRepositoryInterface;

class UserSubscriptionService
{
    public function __construct(
        protected UserSubscriptionRepositoryInterface $userSubscriptionRepository,
        protected MemberPlanRepositoryInterface $memberPlanRepository
    ) {}

    public function getAll(array $args = []): Builder
    {

        if (!empty($args['memberPlan'])) {
            $args['member_plan_id'] = $this->memberPlanRepository->findBySlug($args['memberPlan'])->id;
        }

        return $this->userSubscriptionRepository->getAll($args);
    }

    public function getUserSubscriptionByUuid(string $uuid): ?Subscription
    {
        return $this->userSubscriptionRepository->findByUuid($uuid);
    }

    public function createUserSubscription(array $data): Subscription
    {
        return $this->userSubscriptionRepository->create($data);
    }

    public function updateUserSubscription(string $uuid, array $data): bool
    {
        return $this->userSubscriptionRepository->updateByUuid($uuid, $data);
    }

    public function deleteUserSubscription(string $id): bool
    {
        return $this->userSubscriptionRepository->delete($id);
    }

    public function getByUserId(int $userId): ?Model
    {
        return $this->userSubscriptionRepository->getByUserId($userId);
    }
}
